/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPSEARCHRESPONSE_H
#define QKNXNETIPSEARCHRESPONSE_H

#include <QtKnx/qknxnetipdevicedib.h>
#include <QtKnx/qknxnetipframe.h>
#include <QtKnx/qknxnetiphpai.h>
#include <QtKnx/qknxnetipservicefamiliesdib.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class QKnxNetIpSearchResponseExtendedBuilderPrivate;
class Q_KNX_EXPORT QKnxNetIpSearchResponseProxy final
{
public:
    QKnxNetIpSearchResponseProxy() = delete;
    ~QKnxNetIpSearchResponseProxy() = default;

    QKnxNetIpSearchResponseProxy(const QKnxNetIpFrame &&) = delete;
    explicit QKnxNetIpSearchResponseProxy(const QKnxNetIpFrame &frame);

    bool isValid() const;
    bool isExtended() const;

    QKnxNetIpHpai controlEndpoint() const;
    QKnxNetIpDib deviceHardware() const;
    QKnxNetIpDib supportedFamilies() const;

    QVector<QKnxNetIpDib> optionalDibs() const;
    QVector<QKnxNetIpDib> variableDibs() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setControlEndpoint(const QKnxNetIpHpai &hpai);
        Builder &setDeviceHardware(const QKnxNetIpDib &ddib);
        Builder &setSupportedFamilies(const QKnxNetIpDib &sdib);

        QKnxNetIpFrame create() const;

    private:
        QKnxNetIpHpai m_hpai;
        QKnxNetIpDib m_ddib;
        QKnxNetIpDib m_sdib;
    };
    static QKnxNetIpSearchResponseProxy::Builder builder();

    class Q_KNX_EXPORT ExtendedBuilder final
    {
    public:
        ExtendedBuilder();
        ~ExtendedBuilder();

        ExtendedBuilder &setControlEndpoint(const QKnxNetIpHpai &hpai);
        ExtendedBuilder &setDeviceHardware(const QKnxNetIpDib &ddib);
        ExtendedBuilder &setSupportedFamilies(const QKnxNetIpDib &sdib);
        ExtendedBuilder &setOptionalDibs(const QSet<QKnxNetIpDib> &dibs);

        QKnxNetIpFrame create() const;

        ExtendedBuilder(const ExtendedBuilder &other);
        ExtendedBuilder &operator=(const ExtendedBuilder &other);

    private:
        QSharedDataPointer<QKnxNetIpSearchResponseExtendedBuilderPrivate> d_ptr;
    };
    static QKnxNetIpSearchResponseProxy::ExtendedBuilder extendedBuilder();

private:
    const QKnxNetIpFrame &m_frame;
};

QT_END_NAMESPACE

#endif
